package gov.va.med.mhv.portal.nsoc.redirect;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class NsocDao {

	private JdbcTemplate jdbcTemplate;
	private static final Log LOG = LogFactory.getLog(NsocDao.class);

	@SuppressWarnings("unchecked")
	public List<RedirectUrl> getAllUrls(){
		String sql = "select * from REDIRECT_URL";
		return jdbcTemplate.query(sql, new RedirectUrlRowMapper());
	}

	public RedirectUrl getRedirectUrlByUrl(String url){
		String sql = "select * from REDIRECT_URL where URL = ? and REDIRECT_RULE = 'A'";
		RedirectUrl redirectUrl = new RedirectUrl();
		redirectUrl.setValid(false);
		try{
			redirectUrl = (RedirectUrl) jdbcTemplate.queryForObject(sql, new String[]{url}, new RedirectUrlRowMapper());
			redirectUrl.setValid(true);
		}catch(IncorrectResultSizeDataAccessException ex1){
			if(LOG.isDebugEnabled()){
				LOG.debug("Requested URL not found in DB url=" + url);
			}
			redirectUrl.setValid(false);
			redirectUrl.setErrorMessage("Requested URL not found in DB");
		}catch(DataAccessException ex2){
			if(LOG.isDebugEnabled()){
				LOG.debug("Suspicious/Malformed URL Or Data(URL) Access Violation: " + url);
			}
			LOG.error("Error Trace: ", ex2);
			redirectUrl.setValid(false);
			redirectUrl.setErrorMessage("Suspicious/Malformed URL Or Data(URL) Access Violation.");
		}
		
		return redirectUrl;
	}
	
	public JdbcTemplate getJdbcTemplate() {
		return jdbcTemplate;
	}

	public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
		this.jdbcTemplate = jdbcTemplate;
	}
	
}
